<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:param name="showdesc">
    <xsl:value-of select="1"/>
  </xsl:param>
  <xsl:param name="showurl">
    <xsl:value-of select="1"/>
  </xsl:param>
  <xsl:output method="xml" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" indent="yes"/>

  <xsl:template match="/">
    <html>
	<xsl:call-template name="htmlhead"/>
	<body>
  	  <xsl:apply-templates/>
        <xsl:call-template name="htmlfooter"/>
    	</body>
	</html>
  </xsl:template>
  
  <xsl:template match="channel">
      <xsl:apply-templates select="title"/>
      <div class="pagedescription">
        <xsl:apply-templates select="/rss/channel/image"/>
        <xsl:value-of select="/rss/channel/description"/>
      </div>
      <xsl:apply-templates select="item"/>
  </xsl:template>

  <xsl:template match="title[parent::channel]">
    <h1>
      <a href="{parent::channel/link}">
        <xsl:value-of select="text()"/>
      </a>
    </h1>
  </xsl:template>

  <xsl:template match="link[parent::item]">
    <xsl:if test="$showurl">
      <div class="link">
        <a href="{parent::item/link}">
          <xsl:value-of select="text()"/>
        </a>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template match="description[parent::item]">
    <xsl:if test="$showdesc">
      <div class="description">
        <xsl:value-of select="text()"/>
      </div>
    </xsl:if>
  </xsl:template>

  <xsl:template match="title[parent::item]">
    <div class="title">
      <a href="{../link}">
        <xsl:value-of select="text()"/>
      </a>
    </div>
  </xsl:template>

  <xsl:template match="item">
    <div class="item">
      <xsl:apply-templates select="title"/>
      <xsl:apply-templates select="link"/>
      <xsl:apply-templates select="description"/>
    </div>
  </xsl:template>

  <xsl:template match="image">
    <xsl:if test="url">
      <a href="{/rss/channel/link}">
        <img src="{url}" alt="{title}" width="{width}" height="{height}"/>
      </a>
    </xsl:if>
  </xsl:template>

  <xsl:template name="htmlfooter">
    <hr/>
    <div>
      <xsl:call-template name="validxhtml"/>
      <xsl:call-template name="validcss"/>
    </div>
  </xsl:template>

  <xsl:template name="htmlhead">
    <head>
      <title>
        <xsl:call-template name="title"/>
      </title>
      <meta name="description">
        <xsl:attribute name="content">
          <xsl:call-template name="description"/>
        </xsl:attribute>
      </meta>
      <link rel="stylesheet" type="text/css" href="rss.css"/>
    </head>
  </xsl:template>

  <xsl:template name="title">
    <xsl:value-of select="/rss/channel/title"/>
  </xsl:template>

  <xsl:template name="description">
    <xsl:value-of select="/rss/channel/description"/>
  </xsl:template>

  <xsl:template name="validxhtml">
      <a href="http://validator.w3.org/check/referer">
        <img src="http://www.w3.org/Icons/valid-xhtml10" alt="Valid XHTML 1.0!" height="31" width="88"/>
      </a>
  </xsl:template>
  
  <xsl:template name="validcss">
      <a href="http://jigsaw.w3.org/css-validator/check/referer">
        <img src="http://jigsaw.w3.org/css-validator/images/vcss" height="31" width="88" alt="Valid CSS!"/>
      </a>
  </xsl:template>

  <xsl:template match="text()"/>
  
</xsl:stylesheet>